<?php

use yii\helpers\Html;
use yii\widgets\ActiveForm;

$this->title = 'Регистрация';
$this->params['breadcrumbs'][] = $this->title;
$this->registerCssFile('@web/css/register.css')
?>

<div class="register-container">
    <h1 class="register-title"><?= Html::encode($this->title) ?></h1>

    <?php $form = ActiveForm::begin([
        'id' => 'register-form',
        'options' => ['class' => 'register-form'],
        'fieldConfig' => [
            'template' => "{label}\n{input}\n{error}",
            'labelOptions' => ['class' => 'control-label'],
            'inputOptions' => ['class' => 'form-control'],
            'errorOptions' => ['class' => 'help-block'],
        ],
    ]); ?>

    <?= $form->field($model, 'username')->textInput(['autofocus' => true, 'placeholder' => ' ']) ?>

    <?= $form->field($model, 'email')->input('email', ['placeholder' => ' ']) ?>

    <?= $form->field($model, 'password')->passwordInput(['placeholder' => ' ']) ?>
    <div class="password-hint">Пароль должен содержать не менее 6 символов</div>

    <?= $form->field($model, 'password_repeat')->passwordInput(['placeholder' => ' ']) ?>

    <?= $form->field($model, 'agree')->checkbox([
        'template' => "<div class=\"checkbox-label\">{input} {label}</div>\n<div class=\"col-lg-8\">{error}</div>",
    ]) ?>

    <div class="form-group">
        <?= Html::submitButton('<span>Зарегистрироваться</span>', ['class' => 'btn btn-primary']) ?>
    </div>

    <?php ActiveForm::end(); ?>
</div>