<?php
/** @var yii\web\View $this */
/** @var $model app\models\Travelerprofile */
use app\models\Travelerprofile;
use yii\helpers\Html;
use yii\widgets\ActiveForm;
use yii\helpers\ArrayHelper;

$this->registerCssFile('@web/css/profile.css');

?>

<div class="traveler-profile-view">
    <div class="profile-container">
        <div class="profile-sidebar">
            <div class="profile-avatar-container">
                <img id="avatar-preview" src="<?= $model->getImageUrl() ?>" alt="Profile Image" class="profile-avatar">
            </div>
            <h2><?= Html::encode($model->user->username) ?></h2>

        </div>

        <div class="profile-content">
                <h1 class="profile-title">Профиль пользователя</h1>
                <div class="profile-info-grid">
                    <div class="info-item">
                        <span class="info-label">Возраст:</span>
                        <span class="info-value"><?= $model->age ? Html::encode($model->age) : 'Не указано' ?></span>
                    </div>
                    <div class="info-item">
                        <span class="info-label">Контактная информация:</span>
                        <span class="info-value"><?= $model->contact_info ? Html::encode($model->contact_info) : 'Не указано' ?></span>
                    </div>
                    <div class="info-item">
                        <span class="info-label">Интересы:</span>
                        <span class="info-value"><?= $model->interests_id && isset($items[$model->interests_id]) ?
                                Html::encode($items[$model->interests_id]) : 'Не указано' ?></span>
                    </div>
                    <div class="info-item">
                        <span class="info-label">Бюджет:</span>
                        <span class="info-value"><?= $model->budget_id && isset($itemss[$model->budget_id]) ?
                                Html::encode($itemss[$model->budget_id]) : 'Не указано' ?></span>
                    </div>
                    <div class="info-item">
                        <span class="info-label">Предпочтения в путешествиях:</span>
                        <span class="info-value"><?= $model->travel_preferences ? nl2br(Html::encode($model->travel_preferences)) : 'Не указано' ?></span>
                    </div>
                    <div class="info-item full-width">
                        <span class="info-label">О себе:</span>
                        <div class="info-value bio"><?= $model->bio ? nl2br(Html::encode($model->bio)) : 'Не указано' ?></div>
                    </div>
                </div>
        </div>
    </div>
</div>