<?php

/** @var yii\web\View $this */

use yii\helpers\Html;

$this->title = 'TM';
$this->registerCssFile('@web/css/index.css')
?>
    <a id="but" class="animate-fade-in" style="animation-delay: 0.8s;"><div class="butt animate-fade-in"><p id="ab">Регистрация</p></div></a>
    <div class="bl_1">
        <div class="left-c">
            <h1 class="animate-fade-in" style="animation-delay: 0.2s;"><p class="animate-fade-in" style="animation-delay: 0.4s;">Travel</p> Mates</h1>
            <p class="animate-fade-in" style="animation-delay: 0.6s;">あなたは途中で旅の仲間、そして人生の友人が必要です</p>

        </div>

        <p class="animate-fade-in" style="animation-delay: 1s;">сервис для поиска попутчиков и планирования совместных путешествий</p>
        <div class="airplane-container">
            <img src="image/samolet-1.png" alt="Самолет" class="airplane">
        </div>
    </div>
    <div class="info-section">
        <button class="slider-arrow prev">&#10094;</button>
        <button class="slider-arrow next">&#10095;</button>

        <div class="slider-container">
            <div class="info-block first-block">
                <div class="info-image-container">
                    <img src="../image/ec2f153e7f2f8c78920619d7f8406e35.jpg" alt="Find companion" class="info-image">
                </div>
                <div class="info-content">
                    <h3>Найдите идеального попутчика</h3>
                    <p>Совпадающие интересы, маршруты и бюджет — мы поможем найти того, с кем путешествие станет еще лучше. Общайтесь до поездки и планируйте вместе.</p>
                </div>
            </div>

            <div class="info-block">
                <div class="info-image-container">
                    <img src="../image/5e3daa6759744e5f8ebf022ae526982b.jpg" alt="Plan together" class="info-image">
                </div>
                <div class="info-content">
                    <h3>Планируйте вместе</h3>
                    <p>Совместное создание маршрутов, разделение расходов и обсуждение деталей поездки. Наша платформа предоставляет все необходимые инструменты.</p>
                </div>
            </div>

            <div class="info-block">
                <div class="info-image-container">
                    <img src="../image/pasnyy-nt.jpg" alt="Safety" class="info-image">
                </div>
                <div class="info-content">
                    <h3>Безопасность и надежность</h3>
                    <p>Система рейтингов и отзывов поможет выбрать проверенных попутчиков. Мы проверяем профили и предоставляем инструменты для безопасного общения.</p>
                </div>
            </div>
        </div>

        <div class="slider-nav">
            <div class="slider-dot active"></div>
            <div class="slider-dot"></div>
            <div class="slider-dot"></div>
        </div>
    </div>


    <div class="how-it-works">
        <h2>Как это работает?</h2>
        <div class="steps">
            <div class="step active" data-step="1" style="background-image: url('https://images.unsplash.com/photo-1506929562872-bb421503ef21?ixlib=rb-1.2.1&auto=format&fit=crop&w=1350&q=80')">
                <div class="step-number">1</div>
                <div class="step-content">
                    <h3 class="step-title">Регистрация профиля</h3>
                    <p class="step-text">Создайте подробный профиль, указав свои интересы, предпочтения в путешествиях и уровень комфорта. Это поможет нам найти идеально подходящих попутчиков.</p>
                    <p class="step-details">Наш алгоритм учитывает более 20 параметров для поиска оптимальных совпадений между пользователями.</p>
                </div>
            </div>
            <div class="step" data-step="2" style="background-image: url('https://images.unsplash.com/photo-1483729558449-99ef09a8c325?ixlib=rb-1.2.1&auto=format&fit=crop&w=1350&q=80')">
                <div class="step-number">2</div>
                <div class="step-content">
                    <h3 class="step-title">Поиск путешествия</h3>
                    <p class="step-text">Опубликуйте свое путешествие или найдите существующее предложение в нашем каталоге. Фильтры помогут найти поездки по датам, направлению и бюджету.</p>
                    <p class="step-details">Ежедневно в системе добавляется более 100 новых поездок по всему миру.</p>
                </div>
            </div>
            <div class="step" data-step="3" style="background-image: url('https://images.unsplash.com/photo-1499678329028-101435549a4e?ixlib=rb-1.2.1&auto=format&fit=crop&w=1350&q=80')">
                <div class="step-number">3</div>
                <div class="step-content">
                    <h3 class="step-title">Общение и планирование</h3>
                    <p class="step-text">Свяжитесь с попутчиками через безопасный чат, обсудите детали поездки и договоритесь о совместном путешествии. Наша система проверки профилей обеспечивает безопасность.</p>
                    <p class="step-details">87% пользователей находят попутчиков в течение первых 3 дней после регистрации.</p>
                </div>
            </div>
            <div class="step" data-step="4" style="background-image: url('https://images.unsplash.com/photo-1503220317375-aaad61436b1b?ixlib=rb-1.2.1&auto=format&fit=crop&w=1350&q=80')">
                <div class="step-number">4</div>
                <div class="step-content">
                    <h3 class="step-title">Путешествие и впечатления</h3>
                    <p class="step-text">Отправляйтесь в незабываемое путешествие с новыми друзьями! Делитесь впечатлениями, оставляйте отзывы и планируйте следующие поездки вместе.</p>
                    <p class="step-details">Средний рейтинг наших пользователей составляет 4.8 из 5 на основе более 10,000 отзывов.</p>
                </div>
            </div>
        </div>
    </div>
<script>
    const button = document.querySelector('.butt');
    const buttonText = document.getElementById('ab');
    let isAnimating = false;

    button.addEventListener('click', function() {
        if (isAnimating) return;
        isAnimating = true;

        button.style.marginLeft = '0';
        button.style.width = '100vw';
        buttonText.style.marginLeft = '93px';

        setTimeout(() => {
            button.style.marginTop = '0';
            button.style.height = '100vh';
            buttonText.style.marginTop = '520px';

            setTimeout(() => {
                buttonText.style.opacity = '0';

                setTimeout(() => {
                    window.location.href = "<?= Yii::$app->urlManager->createUrl('site/register') ?>";
                }, 800);
            }, 800);
        }, 800);
    });

    document.addEventListener('DOMContentLoaded', function() {
        const slider = document.querySelector('.slider-container');
        const slides = document.querySelectorAll('.info-block');
        const dots = document.querySelectorAll('.slider-dot');
        const prevBtn = document.querySelector('.prev');
        const nextBtn = document.querySelector('.next');

        let currentSlide = 0;
        const slideCount = slides.length;
        let isTransitioning = false;

        function updateSlider() {
            isTransitioning = true;
            slider.style.transform = `translateX(-${currentSlide * 100}vw)`;

            // Update dots
            dots.forEach((dot, index) => {
                dot.classList.toggle('active', index === currentSlide);
            });

            // Reset transition flag after animation completes
            setTimeout(() => {
                isTransitioning = false;
            }, 600);
        }

        function goToSlide(slideIndex) {
            if (isTransitioning) return;
            currentSlide = slideIndex;
            updateSlider();
        }

        function nextSlide() {
            if (isTransitioning) return;
            currentSlide = (currentSlide + 1) % slideCount;
            updateSlider();
        }

        function prevSlide() {
            if (isTransitioning) return;
            currentSlide = (currentSlide - 1 + slideCount) % slideCount;
            updateSlider();
        }

        // Event listeners
        nextBtn.addEventListener('click', nextSlide);
        prevBtn.addEventListener('click', prevSlide);

        dots.forEach((dot, index) => {
            dot.addEventListener('click', () => goToSlide(index));
        });

        // Keyboard navigation
        document.addEventListener('keydown', function(e) {
            if (e.key === 'ArrowRight') {
                nextSlide();
            } else if (e.key === 'ArrowLeft') {
                prevSlide();
            }
        });

        // Auto-slide (optional)
        // let slideInterval = setInterval(nextSlide, 5000);

        // Pause auto-slide on hover
        // slider.addEventListener('mouseenter', () => clearInterval(slideInterval));
        // slider.addEventListener('mouseleave', () => {
        //     clearInterval(slideInterval);
        //     slideInterval = setInterval(nextSlide, 5000);
        // });

        // Initialize
        updateSlider();
    });

    document.addEventListener('DOMContentLoaded', function() {
        const steps = document.querySelectorAll('.step');
        let currentActive = 0;
        let intervalId;
        const intervalTime = 7000; // 5 секунд

        function nextStep() {
            currentActive = (currentActive + 1) % steps.length;
            setActiveStep(steps[currentActive]);
        }

        function setActiveStep(activeStep) {
            steps.forEach(step => {
                step.classList.remove('active');
            });
            activeStep.classList.add('active');
        }

        setActiveStep(steps[0]);

        steps.forEach((step, index) => {
            step.addEventListener('click', function() {
                currentActive = index;
                setActiveStep(this);
                resetInterval();
            });
        });

        function startInterval() {
            intervalId = setInterval(nextStep, intervalTime);
        }

        function resetInterval() {
            clearInterval(intervalId);
            startInterval();
        }

        startInterval();

        const stepsContainer = document.querySelector('.steps');
        stepsContainer.addEventListener('mouseenter', () => {
            clearInterval(intervalId);
        });

        stepsContainer.addEventListener('mouseleave', () => {
            startInterval();
        });
    });
</script>