<?php
/** @var yii\web\View $this */
/** @var $model app\models\Travelerprofile */
use app\models\Travelerprofile;
use yii\helpers\Html;
use yii\widgets\ActiveForm;
use yii\helpers\ArrayHelper;

$this->registerCssFile('@web/css/create.css');

?>



<div class="traveler-profile-view">
    <div class="profile-container">
        <div class="profile-sidebar">
            <div class="profile-avatar-container">
                <!-- Добавляем id для превью аватарки -->
                <img id="avatar-preview" src="<?= $model->getImageUrl(null) ?>" alt="Profile Image" class="profile-avatar">
                <?php if ($editMode): ?>
                    <label for="travelerprofile-imagefile" class="avatar-upload-label">
                        <i class="fas fa-camera"></i>
                    </label>
                    <?php $form = ActiveForm::begin(['options' => ['enctype' => 'multipart/form-data']]); ?>
                    <?= $form->field($model, 'imageFile', [
                        'options' => ['class' => 'avatar-upload-input'],
                        'inputOptions' => ['style' => 'display: none;']
                    ])->fileInput(['id' => 'travelerprofile-imagefile', 'accept' => 'image/*'])->label(false) ?>
                <?php endif; ?>
            </div>
            <h2><?= Html::encode(Yii::$app->user->identity->username) ?></h2>
            <p><?= $editMode ? 'Редактируйте информацию' : 'Ваш профиль' ?></p>

            <?php if (!$editMode): ?>
                <button class="btn-edit-profile" onclick="location.href='<?= Yii::$app->urlManager->createUrl(['site/create', 'edit' => 1]) ?>'">
                    <i class="fas fa-edit"></i> Редактировать профиль
                </button>
            <?php endif; ?>
        </div>

        <div class="profile-content">
            <?php if ($editMode): ?>
                <h1 class="profile-title">Редактирование профиля</h1>
                <div class="form-grid">
                    <?= $form->field($model, 'age')->textInput(['type' => 'number', 'class' => 'form-control', 'nullable' => true]) ?>
                    <?= $form->field($model, 'contact_info')->textInput(['maxlength' => true, 'class' => 'form-control', 'nullable' => true]) ?>
                    <?= $form->field($model, 'travel_preferences')->textarea(['rows' => 3, 'class' => 'form-control', 'nullable' => true]) ?>
                    <?= $form->field($model, 'interests_id')->dropdownList($items, [
                        'prompt' => 'Выберите интересы',
                        'class' => 'form-control',
                        'nullable' => true
                    ]) ?>
                    <?= $form->field($model, 'budget_id')->dropdownList($itemss, [
                        'prompt' => 'Выберите бюджет',
                        'class' => 'form-control',
                        'nullable' => true
                    ]) ?>
                    <?= $form->field($model, 'bio')->textarea(['rows' => 5, 'class' => 'form-control', 'nullable' => true]) ?>
                </div>
                <div class="form-actions">
                    <?= Html::submitButton('Сохранить', ['class' => 'btn-save']) ?>
                    <?= Html::a('Отмена', ['site/create', 'edit' => 0], ['class' => 'btn-cancel']) ?>
                </div>
                <?php ActiveForm::end(); ?>
            <?php else: ?>
                <h1 class="profile-title">Мой профиль</h1>
                <div class="profile-info-grid">
                    <div class="info-item">
                        <span class="info-label">Возраст:</span>
                        <span class="info-value"><?= $model->age ? Html::encode($model->age) : 'Не указано' ?></span>
                    </div>
                    <div class="info-item">
                        <span class="info-label">Контактная информация:</span>
                        <span class="info-value"><?= $model->contact_info ? Html::encode($model->contact_info) : 'Не указано' ?></span>
                    </div>
                    <div class="info-item">
                        <span class="info-label">Интересы:</span>
                        <span class="info-value"><?= $model->interests_id && isset($items[$model->interests_id]) ?
                                Html::encode($items[$model->interests_id]) : 'Не указано' ?></span>
                    </div>
                    <div class="info-item">
                        <span class="info-label">Бюджет:</span>
                        <span class="info-value"><?= $model->budget_id && isset($itemss[$model->budget_id]) ?
                                Html::encode($itemss[$model->budget_id]) : 'Не указано' ?></span>
                    </div>
                    <div class="info-item">
                        <span class="info-label">Предпочтения в путешествиях:</span>
                        <span class="info-value"><?= $model->travel_preferences ? nl2br(Html::encode($model->travel_preferences)) : 'Не указано' ?></span>
                    </div>
                    <div class="info-item full-width">
                        <span class="info-label">О себе:</span>
                        <div class="info-value bio"><?= $model->bio ? nl2br(Html::encode($model->bio)) : 'Не указано' ?></div>
                    </div>
                </div>
            <?php endif; ?>
        </div>
    </div>
</div>

<script>
        // Функция для блокировки/разблокировки формы
        function toggleFormSubmit(disabled) {
            $('form').find('button[type="submit"]').prop('disabled', disabled);
        }

        // Обработка изменения файла аватарки
        $('#travelerprofile-imagefile').on('change', function(e) {
            const file = e.target.files[0];
            toggleFormSubmit(false);

            if (!file) {
                return;
            }

            // Проверка размера файла (2MB)
            if (file.size > 2 * 1024 * 1024) {
                showNotification('Файл слишком большой. Максимальный размер: 2MB', 'alert-error');
                $(this).val('');
                toggleFormSubmit(true);
                return;
            }

            // Проверка типа файла
            const validExtensions = ['jpeg', 'jpg', 'png', 'webp', 'gif'];
            const fileExt = file.name.split('.').pop().toLowerCase();

            if (!validExtensions.includes(fileExt)) {
                showNotification('Допустимы только изображения: JPG, PNG, WEBP или GIF', 'alert-error');
                $(this).val('');
                toggleFormSubmit(true);
                return;
            }

            showNotification(`Выбрано: ${file.name} (${(file.size / 1024 / 1024).toFixed(2)}MB)`, 'alert-info');

            // Превью изображения
            const reader = new FileReader();
            reader.onload = function(event) {
                $('#avatar-preview').attr('src', event.target.result);
            }
            reader.readAsDataURL(file);
        });

        // Блокировка отправки формы при ошибках
        $('form').on('submit', function(e) {
            const fileInput = $('#travelerprofile-imagefile')[0];
            if (fileInput.files.length > 0) {
                const file = fileInput.files[0];
                const validExtensions = ['jpeg', 'jpg', 'png', 'webp', 'gif'];
                const fileExt = file.name.split('.').pop().toLowerCase();

                if (!validExtensions.includes(fileExt)) {
                    e.preventDefault();
                    showNotification('Невозможно отправить форму: неверный формат изображения', 'alert-error');
                    return false;
                }

                if (file.size > 2 * 1024 * 1024) {
                    e.preventDefault();
                    showNotification('Невозможно отправить форму: файл слишком большой', 'alert-error');
                    return false;
                }
            }
            return true;
        });

        // Обработка успешного сохранения формы (если есть flash-сообщения)
        <?php if (Yii::$app->session->hasFlash('success')): ?>
        showNotification('<?= Yii::$app->session->getFlash('success') ?>', 'alert-success');
        <?php endif; ?>

        <?php if (Yii::$app->session->hasFlash('error')): ?>
        showNotification('<?= Yii::$app->session->getFlash('error') ?>', 'alert-error');
        <?php endif; ?>
    });
</script>
