<?php
use yii\helpers\Html;
use yii\helpers\Url;

$this->title = 'Маршрут: ' . $model->description;
$this->params['breadcrumbs'][] = ['label' => 'Все маршруты', 'url' => ['index']];
$this->params['breadcrumbs'][] = $this->title;
$this->registerCssFile('@web/css/view.css')
?>

<div class="route-view">
    <div class="route-header">
        <h1><?= Html::encode($this->title) ?></h1>

        <?php if ($hasAvailableSeats && !$isJoined): ?>
            <?= Html::a('Присоединиться', ['join', 'id' => $model->id], [
                'class' => 'btn btn-success',
                'data' => [
                    'confirm' => 'Вы точно хотите присоединиться к этому маршруту?',
                    'method' => 'post',
                ],
            ]) ?>
        <?php elseif ($isJoined): ?>
            <span class="badge badge-success">Вы участник</span>
        <?php else: ?>
            <span class="badge badge-secondary">Нет свободных мест</span>
        <?php endif; ?>
    </div>

    <div class="route-details">
        <div class="card">
            <div class="card-body">
                <h3 class="card-title">Детали маршрута</h3>

                <div class="row">
                    <div class="col-md-6">
                        <p><strong>Дата:</strong> <?= Yii::$app->formatter->asDate($model->planned_date) ?></p>
                        <p><strong>Свободных мест:</strong>
                            <?= $model->getAvailableSeatsCount() ?> из <?= $model->seats_available ?>
                        </p>
                    </div>
                    <div class="col-md-6">
                        <p><strong>Организатор:</strong> <?= Html::a($model->user->username, ['user/view', 'id' => $model->user_id]) ?></p>
                        <p><strong>Создан:</strong> <?= Yii::$app->formatter->asDatetime($model->created_at) ?></p>
                    </div>
                </div>

                <h4>Маршрут:</h4>
                <ul class="route-path">
                    <?php if ($model->city1): ?>
                        <li><?= $model->city1->name ?></li>
                    <?php endif; ?>
                    <?php if ($model->city2): ?>
                        <li>→ <?= $model->city2->name ?></li>
                    <?php endif; ?>
                    <?php if ($model->city3): ?>
                        <li>→ <?= $model->city3->name ?></li>
                    <?php endif; ?>
                </ul>

                <?php if ($model->additional_info): ?>
                    <h4>Дополнительная информация:</h4>
                    <p><?= nl2br(Html::encode($model->additional_info)) ?></p>
                <?php endif; ?>
            </div>
        </div>

        <div class="route-members mt-4">
            <h3>Участники:</h3>
            <div class="list-group">
                <div class="list-group-item">
                    <?= Html::a($model->user->username, ['user/view', 'id' => $model->user_id]) ?>
                    <span class="badge badge-primary">Организатор</span>
                </div>
                <?php if ($model->user_id_2): ?>
                    <div class="list-group-item">
                        <?= Html::a($model->user2->username, ['user/view', 'id' => $model->user_id_2]) ?>
                    </div>
                <?php endif; ?>
                <?php if ($model->user_id_3): ?>
                    <div class="list-group-item">
                        <?= Html::a($model->user3->username, ['user/view', 'id' => $model->user_id_3]) ?>
                    </div>
                <?php endif; ?>
                <?php if ($model->user_id_4): ?>
                    <div class="list-group-item">
                        <?= Html::a($model->user4->username, ['user/view', 'id' => $model->user_id_4]) ?>
                    </div>
                <?php endif; ?>
                <?php if ($model->user_id_5): ?>
                    <div class="list-group-item">
                        <?= Html::a($model->user5->username, ['user/view', 'id' => $model->user_id_5]) ?>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>
