<?php

namespace app\models;

use Yii;

/**
 * This is the model class for table "route".
 *
 * @property int $id
 * @property int $user_id
 * @property string $description
 * @property string|null $additional_info
 * @property int $seats_available
 * @property string $created_at
 * @property int $city_id_1
 * @property int|null $city_id_2
 * @property int|null $city_id_3
 * @property int|null $user_id_2
 * @property int|null $user_id_3
 * @property int|null $user_id_4
 * @property int|null $user_id_5
 *
 * @property City $cityId1
 * @property City $cityId2
 * @property City $cityId3
 * @property User $user
 */
class Route extends \yii\db\ActiveRecord
{
    public $country_id;
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'route';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['user_id', 'description', 'created_at', 'city_id_1', 'planned_date'], 'required'],
            [['user_id', 'seats_available', 'city_id_1', 'city_id_2', 'city_id_3', 'user_id_2', 'user_id_3', 'user_id_4', 'user_id_5'], 'integer'],
            [['description', 'additional_info'], 'string'],
            [['created_at'], 'safe'],
            [['user_id'], 'exist', 'skipOnError' => true, 'targetClass' => User::class, 'targetAttribute' => ['user_id' => 'id']],
            [['city_id_1'], 'exist', 'skipOnError' => true, 'targetClass' => City::class, 'targetAttribute' => ['city_id_1' => 'id']],
            [['city_id_2'], 'exist', 'skipOnError' => true, 'targetClass' => City::class, 'targetAttribute' => ['city_id_2' => 'id']],
            [['city_id_3'], 'exist', 'skipOnError' => true, 'targetClass' => City::class, 'targetAttribute' => ['city_id_3' => 'id']],
            ['country_id', 'safe'],
            ['planned_date', 'date', 'format' => 'php:Y-m-d'],
            ['planned_date', 'validateFutureDate'],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'user_id' => 'User ID',
            'description' => 'Описание',
            'additional_info' => 'Что-то еще?',
            'seats_available' => 'Людей в поездке',
            'planned_date' => 'Дата поездки',
            'created_at' => 'Created At',
            'city_id_1' => 'City Id 1',
            'city_id_2' => 'City Id 2',
            'city_id_3' => 'City Id 3',
            'user_id_2' => 'User Id 2',
            'user_id_3' => 'User Id 3',
            'user_id_4' => 'User Id 4',
            'user_id_5' => 'User Id 5',
            'country_id' => 'Страна',
        ];
    }

    public function validateFutureDate($attribute)
    {
        if (strtotime($this->$attribute) < strtotime('today')) {
            $this->addError($attribute, 'Дата должна быть сегодня или позднее');
        }
    }
    /**
     * Gets query for [[CityId1]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getCity1()
    {
        return $this->hasOne(City::class, ['id' => 'city_id_1']);
    }

    /**
     * Gets query for [[CityId2]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getCity2()
    {
        return $this->hasOne(City::class, ['id' => 'city_id_2']);
    }

    /**
     * Gets query for [[CityId3]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getCity3()
    {
        return $this->hasOne(City::class, ['id' => 'city_id_3']);
    }

    /**
     * Gets query for [[User]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getUser()
    {
        return $this->hasOne(User::class, ['id' => 'user_id']);
    }
    public function getUser2()
    {
        return $this->hasOne(User::class, ['id' => 'user_id_2']);
    }

    public function getUser3()
    {
        return $this->hasOne(User::class, ['id' => 'user_id_3']);
    }

    public function getUser4()
    {
        return $this->hasOne(User::class, ['id' => 'user_id_4']);
    }

    public function getUser5()
    {
        return $this->hasOne(User::class, ['id' => 'user_id_5']);
    }
    public function joinUser($userId)
    {
        // Проверяем есть ли уже пользователь в маршруте
        if ($this->user_id == $userId ||
            $this->user_id_2 == $userId ||
            $this->user_id_3 == $userId ||
            $this->user_id_4 == $userId ||
            $this->user_id_5 == $userId) {
            return false; // Пользователь уже в маршруте
        }

        // Ищем свободное место
        if (empty($this->user_id_2)) {
            $this->user_id_2 = $userId;
        } elseif (empty($this->user_id_3)) {
            $this->user_id_3 = $userId;
        } elseif (empty($this->user_id_4)) {
            $this->user_id_4 = $userId;
        } elseif (empty($this->user_id_5)) {
            $this->user_id_5 = $userId;
        } else {
            return false; // Нет свободных мест
        }

        return $this->save();
    }

    /**
     * Возвращает количество свободных мест
     */

    public function getAvailableSeatsCount()
    {
        $taken = 0;
        for ($i = 2; $i <= 5; $i++) {
            if (!empty($this->{"user_id_$i"})) $taken++;
        }
        return $this->seats_available - $taken;
    }

    /**
     * Получает список всех участников
     */
    public function getAllParticipants()
    {
        $participants = [$this->user];

        if ($this->user_id_2) $participants[] = $this->user2;
        if ($this->user_id_3) $participants[] = $this->user3;
        if ($this->user_id_4) $participants[] = $this->user4;
        if ($this->user_id_5) $participants[] = $this->user5;

        return $participants;
    }

    public function isUserJoined($userId)
    {
        return in_array($userId, [
            $this->user_id,
            $this->user_id_2,
            $this->user_id_3,
            $this->user_id_4,
            $this->user_id_5
        ]);
    }

    public function addParticipant($userId)
    {
        // Определяем порядок полей для заполнения
        $fields = ['user_id_2', 'user_id_3', 'user_id_4', 'user_id_5'];

        foreach ($fields as $field) {
            if (empty($this->$field)) {
                $this->$field = $userId;
                return $this->save(false); // false - пропустить валидацию
            }
        }

        return false;
    }

    public function hasAvailableSeats()
    {
        $takenSeats = 0;
        $fields = ['user_id_2', 'user_id_3', 'user_id_4', 'user_id_5'];

        foreach ($fields as $field) {
            if (!empty($this->$field)) {
                $takenSeats++;
            }
        }

        return $takenSeats < $this->seats_available;
    }
}
