<?php

namespace app\models;

use Yii;

/**
 * This is the model class for table "budget".
 *
 * @property int $id
 * @property string $name
 *
 * @property Travelerprofile[] $travelerprofiles
 */
class Budget extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'budget';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['name'], 'required'],
            [['name'], 'string', 'max' => 52],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'name' => 'Name',
        ];
    }

    /**
     * Gets query for [[Travelerprofiles]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getTravelerprofiles()
    {
        return $this->hasMany(Travelerprofile::class, ['budget' => 'id']);
    }
}
