<?php

namespace app\controllers;

use app\models\Budget;
use app\models\Interests;
use app\models\Travelerprofile;
use app\models\User;
use Yii;
use yii\filters\AccessControl;
use yii\web\Controller;
use yii\web\Response;
use yii\filters\VerbFilter;
use app\models\LoginForm;
use app\models\ContactForm;
use yii\web\UploadedFile;
use yii\widgets\ActiveForm;

class SiteController extends Controller
{
    /**
     * {@inheritdoc}
     */
    public function behaviors()
    {
        return [
            'access' => [
                'class' => AccessControl::class,
                'only' => ['logout'],
                'rules' => [
                    [
                        'actions' => ['logout'],
                        'allow' => true,
                        'roles' => ['@'],
                    ],
                ],
            ],
            'verbs' => [
                'class' => VerbFilter::class,
                'actions' => [
                    'logout' => ['post'],
                ],
            ],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function actions()
    {
        return [
            'error' => [
                'class' => 'yii\web\ErrorAction',
            ],
            'captcha' => [
                'class' => 'yii\captcha\CaptchaAction',
                'fixedVerifyCode' => YII_ENV_TEST ? 'testme' : null,
            ],
        ];
    }

    /**
     * Displays homepage.
     *
     * @return string
     */
    public function actionIndex()
    {
        return $this->render('index');
    }

    /**
     * Login action.
     *
     * @return Response|string
     */
    public function actionLogin()
    {
        if (!Yii::$app->user->isGuest) {
            return $this->goHome();
        }

        $model = new LoginForm();
        if ($model->load(Yii::$app->request->post()) && $model->login()) {
            return $this->redirect(['site/create']);
        }

        $model->password = '';
        return $this->render('login', [
            'model' => $model,
        ]);
    }

    /**
     * Logout action.
     *
     * @return Response
     */
    public function actionLogout()
    {
        Yii::$app->user->logout();

        return $this->goHome();
    }

    /**
     * Displays contact page.
     *
     * @return Response|string
     */
    public function actionContact()
    {
        $model = new ContactForm();
        if ($model->load(Yii::$app->request->post()) && $model->contact(Yii::$app->params['adminEmail'])) {
            Yii::$app->session->setFlash('contactFormSubmitted');

            return $this->refresh();
        }
        return $this->render('contact', [
            'model' => $model,
        ]);
    }

    /**
     * Displays about page.
     *
     * @return string
     */
    public function actionAbout()
    {
        return $this->render('about');
    }

    public function actionCreate( $edit = 0)
    {
        $userId = Yii::$app->user->getId();
        $model = Travelerprofile::findOne(['user_id' => $userId]) ?? new Travelerprofile();
        if ($model === null) {
            $model = new Travelerprofile();
            $model->user_id = $userId;
        };

        $editMode = (bool)$edit;
        if ($editMode && $model->load(Yii::$app->request->post())) {
            if ($model->save()) {
            Yii::$app->session->setFlash('success', 'Профиль успешно обновлен');
            return $this->redirect(['site/create']);
            }
        }
        if ($model->isNewRecord && !$editMode) {
            // Если профиля нет и не режим редактирования - сразу переходим в режим редактирования
            return $this->redirect(['site/create', 'edit' => 1]);
        }
        $items = Interests::find()->select(['name'])->indexBy('id')->column();
        $itemss = Budget::find()->select(['name'])->indexBy('id')->column();
        if ($model->load(Yii::$app->request->post())) {
            $model->imageFile = UploadedFile::getInstance($model, 'imageFile');
            if ($model->save()) {
                Yii::$app->session->setFlash('success', 'Профиль успешно сохранен!');
                return $this->redirect(['site/create']);
            } else {
                Yii::$app->session->setFlash('error', 'Ошибка при сохранении профиля.');
            }
        }
        return $this->render('create', [
            'model' => $model,
            'items' => $items,
            'itemss' => $itemss,
            'editMode' => $editMode
        ]);
    }

    public function actionProfile($id)
    {
        $model = Travelerprofile::findOne(['user_id' => $id]);
        $items = Interests::find()->select(['name'])->indexBy('id')->column();
        $itemss = Budget::find()->select(['name'])->indexBy('id')->column();
        return $this->render('profile', [
            'model' => $model,
            'items' => $items,
            'itemss' => $itemss,
        ]);
    }

    public function actionRegister()
    {
        $model = new User();

        if ($model->load(Yii::$app->request->post())) {
            if ($model->validate()) {
                $model->save(false); // false чтобы не валидировать повторно

                // Авторизуем пользователя сразу после регистрации
                Yii::$app->user->login($model);

                Yii::$app->session->setFlash('success', 'Регистрация прошла успешно!');
                return $this->goHome();
            }
        }

        return $this->render('register', [
            'model' => $model,
        ]);
    }


}
