<?php

namespace app\controllers;

use app\models\RouteSearch;
use Yii;
use app\models\Route;
use app\models\Country;
use app\models\City;
use yii\filters\AccessControl;
use yii\web\Controller;
use yii\web\Response;

class RouteController extends Controller
{

    public function actionCreate()
    {
        $model = new Route();
        $model->user_id = Yii::$app->user->id;
        $model->created_at = date('Y-m-d H:i:s');

        $countries = Country::find()->all();

        if ($model->load(Yii::$app->request->post())) {
            if (empty($model->city_id_1)) {
                Yii::$app->session->setFlash('error', 'Выберите хотя бы один город на карте!');
            } elseif ($model->save()) {
                Yii::$app->session->setFlash('success', 'Маршрут успешно создан!');
                return $this->refresh();
            }
        }

        return $this->render('create', [
            'model' => $model,
            'countries' => $countries,
        ]);
    }

    public function actionGetCities($country_id)
    {
        Yii::info("Requested cities for country_id: $country_id", 'application');
        Yii::$app->response->format = Response::FORMAT_JSON;
        $cities = City::find()
        ->where(['country_id' => $country_id])
            ->asArray()
            ->all();

        $result = [];
        foreach ($cities as $city) {
            $result[] = [
                'id' => $city['id'],
                'name' => $city['name'],
                'latitude' => (float)$city['latitude'],
                'longitude' => (float)$city['longitude']
            ];
        }

        return $result;
    }

    public function actionIndex()
    {
        $searchModel = new RouteSearch();
        $dataProvider = $searchModel->search(Yii::$app->request->queryParams);

        return $this->render('index', [
            'searchModel' => $searchModel,
            'dataProvider' => $dataProvider,
        ]);
    }
    protected function findModel($id)
    {
        if (($model = Route::findOne($id)) !== null) {
            return $model;
        }

        throw new NotFoundHttpException('Запрашиваемый маршрут не существует.');
    }

    public function actionView($id)
    {
        $model = $this->findModel($id);
        $currentUserId = Yii::$app->user->id;

        // Проверяем, присоединен ли уже текущий пользователь
        $isJoined = in_array($currentUserId, [
            $model->user_id,
            $model->user_id_2,
            $model->user_id_3,
            $model->user_id_4,
            $model->user_id_5
        ]);

        return $this->render('view', [
            'model' => $model,
            'isJoined' => $isJoined,
            'hasAvailableSeats' => $model->hasAvailableSeats()
        ]);
    }

    public function actionJoin($id)
    {
        $model = $this->findModel($id);
        $currentUserId = Yii::$app->user->id;

        // Проверяем что пользователь еще не присоединен
        if (!$model->isUserJoined($currentUserId)) {
            if ($model->hasAvailableSeats()) {
                // Добавляем пользователя
                if ($model->addParticipant($currentUserId)) {
                    Yii::$app->session->setFlash('success', 'Вы успешно присоединились!');
                } else {
                    Yii::$app->session->setFlash('error', 'Ошибка при сохранении. Пожалуйста, попробуйте позже.');
                    Yii::error('Ошибка сохранения маршрута: ' . print_r($model->errors, true));
                }
            } else {
                Yii::$app->session->setFlash('error', 'Нет свободных мест');
            }
        } else {
            Yii::$app->session->setFlash('warning', 'Вы уже присоединены');
        }

        return $this->redirect(['view', 'id' => $id]);
    }
}